#==============================================================================
#  Markup_New_Line
#------------------------------------------------------------------------------
# sw}[NAbv
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# \n s
#
#==============================================================================

module Markup_New_Line
  @@indent = 0
  @@line_height = Font.default_size + 2
  module_function
  def query
    return /^\\n/
  end
  def transfer(bmp, x, y, text, match)
    text[query] = ''
    return @@indent,y + @@line_height,text
  end
  def line_height=(n)
    @@line_height = n
  end
  def indent=(n)
    @@indent = n
  end
  def line_height
    return @@line_height
  end
end

module Markup_Line_Height
  module_function
  def query
    return /^\\line_height\[([0-9]+)\]/
  end
  def transfer(bmp, x, y, text, match)
    text[query] = ''
    Markup_New_Line.line_height = match[1].to_i
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_New_Line)
String_Operation_Module.add_markup(Markup_Line_Height)
